/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.PlanningAlgorithm;
import cz.insophy.inplan.planning.PlanningAlgorithmInfo;
import cz.insophy.inplan.planning.PlanningAlgorithmSupport;
import cz.insophy.inplan.planning.PlanningUnit;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.OperationBuilder;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.StartEndQtyUpdater;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.io.Writer;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
implements PlanningAlgorithm {
    private static final boolean DEBUG = false;
    private static final Logger log = LoggerFactory.getLogger(Scheduler.class);
    private PlanningAlgorithmSupport pas;
    private Superplan superplan;
    private Set<Operation> opsView;
    private Set<Operation> ops;
    private List<Operation> plannedOps;
    private List<Processor> processors;
    private final Map<Processor, ProcessorStats> processorStats = Maps.newIdentityHashMap();
    private boolean useExplicitChaining = true;
    private boolean useFeedsChaining;
    private boolean stopped;
    private boolean stopRequested;
    private Writer debugWriter = null;
    private int garCount = 0;

    public Scheduler() {
        this.processors = Collections.emptyList();
    }

    @VisibleForTesting
    protected Scheduler(Superplan superplan) {
        this();
        this.setSuperplan(superplan);
        this.afterPropertiesSet();
    }

    public void setSuperplan(Superplan superplan) {
        Preconditions.checkNotNull(superplan);
        this.superplan = superplan;
    }

    public void afterPropertiesSet() {
        this.initOps();
        this.pas = new PlanningAlgorithmSupport();
        this.initPlanningAlgorithmSupport();
        for (Processor processor : this.processors) {
            processor.setScheduler(this);
            this.processorStats.put(processor, new ProcessorStats());
        }
    }

    private void initOps() {
        OperationBuilder operationBuilder = new OperationBuilder(this.superplan);
        operationBuilder.setUseExplicitChaining(this.useExplicitChaining);
        operationBuilder.setUseFeedsChaining(this.useFeedsChaining);
        this.ops = operationBuilder.build();
        this.opsView = UnmodifiableChangeTrackingSet.create((ChangeTrackingSet)this.ops);
        this.plannedOps = Lists.newArrayListWithCapacity(this.ops.size());
        this.garCount = operationBuilder.getGarCount();
    }

    public Superplan getSuperplan() {
        return this.superplan;
    }

    public Set<Operation> getOperations() {
        return Collections.unmodifiableSet(this.ops);
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public List<Processor> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public <T extends Processor> Iterable<T> getProcessors(Class<T> cls) {
        return this.processors.stream().filter(cls::isInstance).map(cls::cast).toList();
    }

    public void setUseExplicitChaining(boolean useExplicitChaining) {
        this.useExplicitChaining = useExplicitChaining;
    }

    public void setUseFeedsChaining(boolean useFeedsChaining) {
        this.useFeedsChaining = useFeedsChaining;
    }

    public void schedule() {
        Object stats;
        RuntimeException schedulingException;
        block18: {
            StringBuilder sb = new StringBuilder();
            this.stopped = false;
            schedulingException = null;
            try {
                while (!this.ops.isEmpty() && !this.pas.isCanceled()) {
                    Processor p = this.processors.get(0);
                    Set<Operation> workOps = this.opsView;
                    long start = System.nanoTime();
                    this.stopRequested = false;
                    do {
                        stats = this.processorStats.get(p);
                        long processStart = System.nanoTime();
                        Tuple<Processor, Set<Operation>> pRes = p.process(workOps);
                        ((ProcessorStats)stats).processTime += System.nanoTime() - processStart;
                        ++((ProcessorStats)stats).invocationCount;
                        ((ProcessorStats)stats).opCount += (long)workOps.size();
                        p = pRes.getFirst();
                        workOps = pRes.getSecond();
                        if (!this.stopRequested) continue;
                        if (this.stopped) break block18;
                        p = null;
                        workOps = Collections.emptySet();
                    } while (p != null && !workOps.isEmpty());
                    for (Operation plannedOp : workOps) {
                        Preconditions.checkState(plannedOp.getPlannings().size() == 1, "Processors must return operations with exactly one planning.");
                        this.applyToPlan(plannedOp);
                        plannedOp.setPlanned(true);
                        for (Operation altOp : plannedOp.getOtherLaOps()) {
                            this.ops.remove(altOp);
                            for (Operation succ : ImmutableList.copyOf(altOp.getSuccessors())) {
                                succ.removePredecessor(altOp);
                                altOp.removeSuccessor(succ);
                            }
                            for (Operation pred : ImmutableList.copyOf(altOp.getPredecessors())) {
                                pred.removeSuccessor(altOp);
                                altOp.removePredecessor(pred);
                            }
                            altOp.clearPlannings();
                            altOp.setPlanned(true);
                        }
                        for (Processor proc : this.processors) {
                            long oopStart = System.nanoTime();
                            proc.onOperationPlanned(plannedOp);
                            this.processorStats.get((Object)proc).opOpPlannedTime += System.nanoTime() - oopStart;
                        }
                        this.ops.remove(plannedOp);
                        this.plannedOps.add(plannedOp);
                        this.pas.finishedPlanningUnits(1);
                    }
                }
            }
            catch (RuntimeException e) {
                log.error("An exception occurred during planning.", e);
                schedulingException = e;
            }
        }
        this.pas.setComplete(this.ops.isEmpty());
        this.pas.finishedPlanning();
        if (this.pas.isApplyToSuperplan()) {
            for (Processor p : this.processors) {
                p.onPlanningFinished();
            }
            StartEndQtyUpdater.updateFrom(this.superplan);
        } else {
            for (Operation appliedOp : Lists.reverse(this.plannedOps)) {
                this.removeFromPlan(appliedOp);
            }
        }
        if (log.isDebugEnabled()) {
            StringBuilder s2 = new StringBuilder();
            Formatter f = new Formatter(s2);
            s2.append("Times taken in: process [s], onOperationPlanned [s], total [s], call count, avg ops\n");
            for (Processor p : this.processors) {
                stats = this.processorStats.get(p);
                double pTime = (double)((ProcessorStats)stats).processTime / 1.0E9;
                double oopTime = (double)((ProcessorStats)stats).opOpPlannedTime / 1.0E9;
                double avgOps = (double)((ProcessorStats)stats).opCount / (double)((ProcessorStats)stats).invocationCount;
                f.format("%28s %8.3f %8.3f %8.3f %9d %11.2f\n", p.getClass().getSimpleName(), pTime, oopTime, pTime + oopTime, ((ProcessorStats)stats).invocationCount, avgOps);
            }
            log.debug(s2.toString());
        }
        for (Processor processor : this.processors) {
            processor.destroy();
        }
        if (schedulingException != null) {
            throw schedulingException;
        }
    }

    public void stopPlanning() {
        if (!this.stopped) {
            String stopperClass = Thread.currentThread().getStackTrace()[2].getClassName();
            this.stopped = true;
            this.stopRequested = true;
            for (Processor processor : this.processors) {
                if (processor.onPlanningStopping()) continue;
                this.stopped = false;
                log.debug("{} requested to stop planning but it was vetoed by {}", (Object)stopperClass, (Object)processor.getClass().getName());
                break;
            }
            if (this.stopped) {
                log.info("{} successfully requested to stop planning.", (Object)stopperClass);
            }
        }
    }

    private void initPlanningAlgorithmSupport() {
        this.pas.setPlanningUnit(PlanningUnit.GAR);
        this.pas.setPlanningUnitCount(this.garCount);
        PlanningAlgorithmInfo pai = new PlanningAlgorithmInfo();
        pai.setCancelable(true);
        pai.setStoppable(true);
        pai.setFitness(false);
        pai.setIterations(false);
        pai.setUnits(true);
        this.pas.setPlanningAlgorithmInfo(pai);
    }

    @Override
    public PlanningAlgorithmSupport getPlanningAlgorithmSupport() {
        return this.pas;
    }

    private void applyToPlan(Operation plannedOp) {
        GeneralizedActionRequest gar = plannedOp.getGar();
        List<ActivityChange> changes = plannedOp.getPlannings().iterator().next().getActivityChanges();
        this.superplan.getPlan().registerChanges(changes);
        if (plannedOp.getAction() != gar.getAction()) {
            gar.setAction(plannedOp.getAction());
        }
        for (ActivityChange change : changes) {
            if (!(change.getActivity() instanceof ActionActivity) || change.getChangeType() != ActivityChange.ChangeType.ADDED) continue;
            gar.unsafeAddActivity((ActionActivity)change.getActivity());
        }
    }

    private void removeFromPlan(Operation appliedOp) {
        GeneralizedActionRequest gar = appliedOp.getGar();
        List<ActivityChange> changes = appliedOp.getPlannings().iterator().next().getActivityChanges();
        for (ActivityChange change : changes) {
            if (!(change.getActivity() instanceof ActionActivity) || change.getChangeType() != ActivityChange.ChangeType.ADDED) continue;
            gar.unsafeRemoveActivity((ActionActivity)change.getActivity());
        }
        this.superplan.getPlan().unregisterChanges(changes);
    }

    private static class ProcessorStats {
        long processTime;
        long opOpPlannedTime;
        long opCount;
        long invocationCount;

        private ProcessorStats() {
        }
    }
}

